options(width = 120)
#********************************************************************************#
#*                                                                               #
#*  Purpose: R program to create a permanent R.RDS data set with the             #
#*           CPS May 2019 survey data. The program reads the file                #
#*           may19pub and creates the file CPSMAY19.RDS                          #
#*                                                                               #
#*  Notes:   The program uses the package readr                                  #
#                                                                                #
#********************************************************************************#

##################################################################################
## Create data dictionary with varaible names, witdths, type and labels
##################################################################################

library(readr)
data_diccionary <-
'HRHHID       0001  0015 character  "Household identifier (part 1)"
HRMONTH      0016  0017 numeric    "Month of interview"
HRYEAR4      0018  0021 numeric    "Year of interview"
HURESPLI     0022  0023 numeric    "Line number of the current respondent"
HUFINAL      0024  0026 numeric    "Final outcome code"
HETENURE     0029  0030 numeric    "Are your living quarters..."
HEHOUSUT     0031  0032 numeric    "Type of housing unit"
HETELHHD     0033  0034 numeric    "Is there a telephone in this house/apartment? "
HETELAVL     0035  0036 numeric    "Is there a telephone elsewhere on which people in this household can be contacted?"
HEPHONEO     0037  0038 numeric    "Is a telephone interview acceptable?"
HEFAMINC     0039  0040 numeric    "Family income"
HUTYPEA      0041  0042 numeric    "Type A non-interview reason"
HUTYPB       0043  0044 numeric    "Type B non-interview reason"
HUTYPC       0045  0046 numeric    "Type C non-interview reason"
HWHHWGT      0047  0056 numeric    "Household weight"
HRINTSTA     0057  0058 numeric    "Interview status"             
HRNUMHOU     0059  0060 numeric    "Total number of persons living in the household (household members)"
HRHTYPE      0061  0062 numeric    "Household type"
HRMIS        0063  0064 numeric    "Month-in-sample"
HUINTTYP     0065  0066 numeric    "Type of interview"
HUPRSCNT     0067  0068 numeric    "Number of actual and attempted personal contacts"
HRLONGLK     0069  0070 numeric    "Longitudinal link indicator"
HRHHID2      0071  0075 character  "Household identifier (part 2)"
HWHHWTLN     0076  0077 numeric    "Line Number (PULINENO) of the person whose PWSSWGT was donated as HWHHWGT for the household"
HUBUS        0079  0080 numeric    "Does anyone in this household have a business or a farm?"
HUBUSL1      0081  0082 numeric    "Enter line number for hubus = 1"
HUBUSL2      0083  0084 numeric    "Enter line number for hubus = 1"
HUBUSL3      0085  0086 numeric    "Enter line number for hubus = 1"
HUBUSL4      0087  0088 numeric    "Enter line number for hubus = 1"
GEREG        0089  0090 numeric    "Region"
GEDIV        0091  0091 numeric    "Division"
GESTFIPS     0093  0094 character  "Federal information processing standards (FIPS) state code"
GTCBSA       0096  0100 character  "Specific Metropolitan CBSA code"
GTCO         0101  0103 character  "FIPS county code"
GTCBSAST     0104  0104 numeric    "Principal city/balance status"
GTMETSTA     0105  0105 numeric    "Metropolitan status"
GTINDVPC     0106  0106 numeric    "Individual principal city"
GTCBSASZ     0107  0107 numeric    "Metropolitan area (CBSA) size"
GTCSA        0108  0110 character  "Consolidated statistical area (CSA) FIPS code"
PERRP        0118  0119 numeric    "Relationship to reference person"
PEPARENT     0120  0121 numeric    "Line number of parent"
PRTAGE       0122  0123 numeric    "Persons age"
PRTFAGE      0124  0124 numeric    "Top code flag for age"
PEMARITL     0125  0126 numeric    "Marital status"
PESPOUSE     0127  0128 numeric    "Line number of spouse"
PESEX        0129  0130 numeric    "Sex"
PEAFEVER     0131  0132 numeric    "Did you ever serve on active duty in the U.S. armed forces?"
PEAFNOW      0135  0136 numeric    "Are you now in the armed forces?"
PEEDUCA      0137  0138 numeric    "Highest level of school completed or degree received"
PTDTRACE     0139  0140 numeric    "Race"
PRDTHSP      0141  0142 numeric    "Detailed Hispanic origin group (Revised January 2014)"  
PUCHINHH     0143  0144 numeric    "Change in household composition"
PULINENO     0147  0148 numeric    "Person-s line number"
PRFAMNUM     0151  0152 numeric    "Family number recode"
PRFAMREL     0153  0154 numeric    "Family relationship recode"
PRFAMTYP     0155  0156 numeric    "Family type recode"
PEHSPNON     0157  0158 numeric    "Hispanic or non-Hispanic"
PRMARSTA     0159  0160 numeric    "Marital status based on armed forces participation"
PRPERTYP     0161  0162 numeric    "Type of person record recode"
PENATVTY     0163  0165 numeric    "Country of birth"
PEMNTVTY     0166  0168 numeric    "Mother-s country of birth"
PEFNTVTY     0169  0171 numeric    "Father-s country of birth"
PRCITSHP     0172  0173 numeric    "Citizenship status"
PRCITFLG     0174  0175 numeric    "Citizenship allocation flag"
PRINUSYR     0176  0177 numeric    "Immigrant- s year of entry"
PUSLFPRX     0178  0179 numeric    "Labor force information collected by self or proxy response"
PEMLR        0180  0181 numeric    "Monthly labor force recode"
PUWK         0182  0183 numeric    "Last week, did you do any work for (either) pay (or profit)?"
PUBUS1       0184  0185 numeric    "Last week, did you do any unpaid work in the family business or farm?"
PUBUS2OT     0186  0187 numeric    "Do you receive any payments or profits from the business?"
PUBUSCK1     0188  0189 numeric    "Check item 1 filter for questions on unpaid work"
PUBUSCK2     0190  0191 numeric    "Check item 2 skips owners of family busines who did not work last week"
PUBUSCK3     0192  0193 numeric    "Check item 3"
PUBUSCK4     0194  0195 numeric    "Check item 4"
PURETOT      0196  0197 numeric    "Retirement status (last month you were reported to be retired, are you still retired this month?)"
PUDIS        0198  0199 numeric    "Disability status (last month you were reported to have a disability.) Does your disability continue to prevent you from doing any kind of work for the next 6 months?"
PERET1       0200  0201 numeric    "Do you currently want a job, either full or part-time?"
PUDIS1       0202  0203 numeric    "Does your disability prevent you from accepting any kind of work during the next six months?"
PUDIS2       0204  0205 numeric    "Do you have a disability that prevents you from accepting any kind of work during the next six months?"
PUABSOT      0206  0207 numeric    "Last week did you have a job either full or part-time?"
PULAY        0208  0209 numeric    "Last week, were you on layoff from a job?"
PEABSRSN     0210  0211 numeric    "What is the main reason you were absent from work last week?"
PEABSPDO     0212  0213 numeric    "Are you being paid by your employer for any of the time off last week?"
PEMJOT       0214  0215 numeric    "Do you have more than one job?"
PEMJNUM      0216  0217 numeric    "Altogether, how many jobs did you have?"
PEHRUSL1     0218  0219 numeric    "How many hours per week do you usually work at your main job?"
PEHRUSL2     0220  0221 numeric    "How many hours per week do you usually work at your other (job/jobs)?"
PEHRFTPT     0222  0223 numeric    "Do you usually work 35 hours or more per week?"
PEHRUSLT     0224  0226 numeric    "Sum of HRUSL1 and HRUSL2."
PEHRWANT     0227  0228 numeric    "Do you want to work a full-time work week of 35 hours or more per week?"
PEHRRSN1     0229  0230 numeric    "What is your main reason for working part-time?"
PEHRRSN2     0231  0232 numeric    "What is the main reason you do not want to work full-time?"
PEHRRSN3     0233  0234 numeric    "What is the main reason you worked less than 35 hours last week?"
PUHROFF1     0235  0236 numeric    "Last week, did you lose or take off any hours from your job, for any reason such as illness, slack work, vacation, or holiday?"
PUHROFF2     0237  0238 numeric    "How many hours did you take off?"
PUHROT1      0239  0240 numeric    "Last week, did you work any overtime or extra hours (at your main job) that you do not usually work?"
PUHROT2      0241  0242 numeric    "How many additional hours did you work?"
PEHRACT1     0243  0244 numeric    "Last week, how many hours did you actually work at your job?"
PEHRACT2     0245  0246 numeric    "Last week, how many hours did you actually work at your other (job/jobs)"
PEHRACTT     0247  0249 numeric    "Sum of PEHRACT1 and PEHRACT2"
PEHRAVL      0250  0251 numeric    "Last week, could you have worked full-time if the hours had been available?"
PUHRCK1      0257  0258 numeric    "Check item 1"
PUHRCK2      0259  0260 numeric    "Check item 2 skips persons responding yes to HRFTPT out of PT series"
PUHRCK3      0261  0262 numeric    "Check item 3"
PUHRCK4      0263  0264 numeric    "Check item 4"
PUHRCK5      0265  0266 numeric    "Check item 5"
PUHRCK6      0267  0268 numeric    "Check item 6"
PUHRCK7      0269  0270 numeric    "Check item 7"
PUHRCK12     0271  0272 numeric    "Check item 12"
PULAYDT      0273  0274 numeric    "Has your employer given you a date to return to work?"
PULAY6M      0275  0276 numeric    "Have you been given any indication that you will be recalled to work within the next 6 months?"
PELAYAVL     0277  0278 numeric    "Could you have returned to work last week if you had been recalled?"
PULAYAVR     0279  0280 numeric    "Why is that?"
PELAYLK      0281  0282 numeric    "Even though you are to be called back to work, have you been looking for work during the last 4 weeks."
PELAYDUR     0283  0285 numeric    "Duration of layoff"
PELAYFTO     0286  0287 numeric    "FT/PT status of job from which sample person was on layoff from"
PULAYCK1     0288  0289 numeric    "Check item 1"
PULAYCK2     0290  0291 numeric    "Check item 2 screen for dependent layoff"
PULAYCK3     0292  0293 numeric    "Check item 3 filter for dependent I & O"
PULK         0294  0295 numeric    "Have you been doing anything to find work during the last 4 weeks?"
PELKM1       0296  0297 numeric    "What are all of the things you have done to find work during the last 4 weeks? (first method)"
PULKM2       0298  0299 numeric    "Anything else? (second method)"
PULKM3       0300  0301 numeric    "Anything else? (third method)"
PULKM4       0302  0303 numeric    "Anything else? (fourth method)"
PULKM5       0304  0305 numeric    "Anything else? (fifth method)"
PULKM6       0306  0307 numeric    "Anything else? (sixth method)"
PULKDK1      0308  0309 numeric    "You said you have been trying to find work. How did you go about looking? (first method)"
PULKDK2      0310  0311 numeric    "Anything else? (second method)"
PULKDK3      0312  0313 numeric    "Anything else? (third method)"
PULKDK4      0314  0315 numeric    "Anything else? (fourth method)"
PULKDK5      0316  0317 numeric    "Anything else? (fifth method)"
PULKDK6      0318  0319 numeric    "Anything else? (sixth method)"
PULKPS1      0320  0321 numeric    "Can you tell me more about what you did to search for work? (first method)"
PULKPS2      0322  0323 numeric    "Anything else? (second method)"
PULKPS3      0324  0325 numeric    "Anything else? (third method)"
PULKPS4      0326  0327 numeric    "Anything else? (fourth method)"
PULKPS5      0328  0329 numeric    "Anything else? (fifth method)"
PULKPS6      0330  0331 numeric    "Anything else? (sixth method)"
PELKAVL      0332  0333 numeric    "Last week, could you have started a job if one had been offered?"
PULKAVR      0334  0335 numeric    "Why is that?"
PELKLL1O     0336  0337 numeric    "Before you started looking for work, what were you doing: working, going to school, or something else?"
PELKLL2O     0338  0339 numeric    "Did you lose or quit that job, or was it a temporary job that ended?"
PELKLWO      0340  0341 numeric    "When last worked"
PELKDUR      0342  0344 numeric    "Duration of job seeking"
PELKFTO      0345  0346 numeric    "FT/PT status of jobseeker"
PEDWWNTO     0347  0348 numeric    "Do you currently want a job, either full or part time?"
PEDWRSN      0349  0350 numeric    "What is the main reason you were not looking for work during the last 4 weeks?"
PEDWLKO      0351  0352 numeric    "Did you look for work at any time in the last 12 months"
PEDWWK       0353  0354 numeric    "Did you actually work at a job or business during the last 12 months?"
PEDW4WK      0355  0356 numeric    "Did you do any of this work during the last 4 weeks?"
PEDWLKWK     0357  0358 numeric    "Since you left that job or business have you looked for work?"
PEDWAVL      0359  0360 numeric    "Last week, could you have started a job if one had been offered?"
PEDWAVR      0361  0362 numeric    "Why is that?"
PUDWCK1      0363  0364 numeric    "Screen for discouraged workers"
PUDWCK2      0365  0366 numeric    "Screen for disabled"
PUDWCK3      0367  0368 numeric    "Filter for retired"
PUDWCK4      0369  0370 numeric    "Filter for passive job seekers"
PUDWCK5      0371  0372 numeric    "Filter for passive job seekers"
PEJHWKO      0373  0374 numeric    "Have you worked at a job or business at any time during the past 12 months?"
PUJHDP1O     0375  0376 numeric    "Did you do any of this work in the last 4 weeks?"
PEJHRSN      0377  0378 numeric    "What is the main reason you left your last job?"
PEJHWANT     0379  0380 numeric    "Do you intend to look for work during the next 12 months?"
PUJHCK1      0381  0382 numeric    "Filter for outgoing rotations"
PUJHCK2      0383  0384 numeric    "Filter for persons going through the I and O series"
PRABSREA     0385  0386 numeric    "Reason not at work and pay status"
PRCIVLF      0387  0388 numeric    "Civilian labor force"
PRDISC       0389  0390 numeric    "Discouraged worker recode"
PREMPHRS     0391  0392 numeric    "Reason not at work or hours at work"
PREMPNOT     0393  0394 numeric    "MLR - employed, unemployed, or NILF"
PREXPLF      0395  0396 numeric    "Experienced labor force employment"
PRFTLF       0397  0398 numeric    "Full time labor force" 
PRHRUSL      0399  0400 numeric    "Usual hours worked weekly"
PRJOBSEA     0401  0402 numeric    "Job search recode"
PRPTHRS      0403  0404 numeric    "At work 1-34 by hours at work"
PRPTREA      0405  0406 numeric    "Detailed reason for part-time"
PRUNEDUR     0407  0409 numeric    "Duration of unemployment for layoff and looking records"
PRUNTYPE     0412  0413 numeric    "Reason for unemployment"
PRWKSCH      0414  0415 numeric    "Labor force by time worked or lost"
PRWKSTAT     0416  0417 numeric    "Full/part-time work status"
PRWNTJOB     0418  0419 numeric    "NILF recode - want a job or other NILF"
PUJHCK3      0420  0421 numeric    "Job history check item"
PUJHCK4      0422  0423 numeric    "Screen for dependent NILF"
PUJHCK5      0424  0425 numeric    "Screen for dependent NILF"
PUIODP1      0426  0427 numeric    "Last month, it was reported that you worked for (employer-s name). Do still work for (employer-s name) (at your main job)?"
PUIODP2      0428  0429 numeric    "Have the usual activities and duties of your job changed since last month?"
PUIODP3      0430  0431 numeric    "Last month you were reported as (a/an) (occupation) and your usual activities were (description). Is this an accurate description of your current job?"
PEIO1COW     0432  0433 numeric    "Individual class of worker code on first job"
PUIO1MFG     0434  0435 numeric    "Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?"
PEIO2COW     0442  0443 numeric    "Individual class of worker on second job."
PUIO2MFG     0444  0445 numeric    "Is this business or organization mainly manufacturing, retail trade, wholesale trade, or something else?"
PUIOCK1      0452  0453 numeric    "I & O check item 1 screen for dependent I and O"
PUIOCK2      0454  0455 numeric    "I & O check item 2 screen for previous months I and O cases"
PUIOCK3      0456  0457 numeric    "I & O check item 3"
PRIOELG      0458  0459 numeric    "Industry and occupation eligibility flag"
PRAGNA       0460  0461 numeric    "Agriculture/non-agriculture industry"
PRCOW1       0462  0463 numeric    "Class of worker recode - job 1"
PRCOW2       0464  0465 numeric    "Class of worker recode - job 2"
PRCOWPG      0466  0467 numeric    "COW - private or government"
PRDTCOW1     0468  0469 numeric    "Detailed class of worker recode - job 1"
PRDTCOW2     0470  0471 numeric    "Detailed class of worker recode - job 2"
PRDTIND1     0472  0473 numeric    "Detailed industry recode - job 1"
PRDTIND2     0474  0475 numeric    "Detailed industry recode - job 2"
PRDTOCC1     0476  0477 numeric    "Detailed occupation recode - job 1"
PRDTOCC2     0478  0479 numeric    "Detailed occupation recode - job 2"
PREMP        0480  0481 numeric    "Employed persons (non-farm & non-private hhld) recode"
PRMJIND1     0482  0483 numeric    "Major industry recode - job 1"
PRMJIND2     0484  0485 numeric    "Major industry recode - job 2"
PRMJOCC1     0486  0487 numeric    "Major occupation recode - job 1"
PRMJOCC2     0488  0489 numeric    "Major occupation recode - job 2"
PRMJOCGR     0490  0491 numeric    "Major occupation categories"
PRNAGPWS     0492  0493 numeric    "Non-agriculture, private wage and salary workers recode"
PRNAGWS      0494  0495 numeric    "Non-agriculture wage and salary workers recode"
PRSJMJ       0496  0497 numeric    "Single/multiple jobholder recode"
PRERELG      0498  0499 numeric    "Earnings eligibility flag"
PEERNUOT     0500  0501 numeric    "Do you usually receive overtime pay, tips, or commissions at your job?"
PEERNPER     0502  0503 numeric    "Periodicity"
PEERNRT      0504  0505 numeric    "(Even though you told me it is easier to report your earnings (periodicity); Are you paid at an hourly rate on your (main/this) job?"
PEERNHRY     0506  0507 numeric    "Hourly/nonhourly status"
PUERNH1C     0508  0511 numeric    "What is your hourly rate of pay on this job, excluding overtime pay, tips or commission?"
PEERNH2      0512  0515 numeric    "(Excluding overtime pay, tips and commissions) what is your hourly rate of pay on your (main/this) job?"
PEERNH1O     0516  0519 numeric    "Out variable for hourly rate of pay"
PRERNHLY     0520  0523 numeric    "Recode for hourly rate"
PTHR         0524  0524 numeric    "Hourly pay - top code"
PEERNHRO     0525  0526 numeric    "Usual hours"
PRERNWA      0527  0534 numeric    "Weekly earnings recode"
PTWK         0535  0535 numeric    "Weekly earnings - top code"
PEERN        0540  0547 numeric    "Calculated weekly overtime amount"
PUERN2       0548  0555 numeric    "Calculated weekly overtime amount"
PTOT         0556  0556 numeric    "Weekly overtime amount - top code"
PEERNWKP     0559  0560 numeric    "How many weeks a year do you get paid for?"
PEERNLAB     0561  0562 numeric    "On this job, are you a member of a labor union or of an employee association similar to a union?"
PEERNCOV     0563  0564 numeric    "On this job are you covered by a union or employee association contract?"
PENLFJH      0565  0566 numeric    "When did you last work at a job or business?"
PENLFRET     0567  0568 numeric    "Are you retired from a job or business?"
PENLFACT     0569  0570 numeric    "What best describes your situation at this time? For example, are you disabled, ill, in school, taking care of house or family, or something else?"
PUNLFCK1     0571  0572 numeric    "Not in labor force check item - 1"
PUNLFCK2     0573  0574 numeric    "Not in labor force check item - 2"
PESCHENR     0575  0576 numeric    "Last week, were you enrolled in a high school, college, or university?"
PESCHFT      0577  0578 numeric    "Are you enrolled in school as a full-time or part-time student?"
PESCHLVL     0579  0580 numeric    "Would that be high school, college, or university?"
PRNLFSCH     0581  0582 numeric    "NLF activity - in school or not in school"
PWFMWGT      0583  0592 numeric    "Family weight"
PWLGWGT      0593  0602 numeric    "Longitudinal weight" 
PWORWGT      0603  0612 numeric    "Outgoing rotation weight"
PWSSWGT      0613  0622 numeric    "Final weight"
PWVETWGT     0623  0632 numeric    "Veterans weight"
PRCHLD       0633  0634 numeric    "Presence of own children < 18 years of age by selected age group"
PRNMCHLD     0635  0636 numeric    "Number of own children < 18 years of age"          
PXPDEMP1     0637  0638 numeric    "Allocation flag"
PRWERNAL     0639  0640 numeric    "Allocation flag weekly earnings recode (PRERNWA)"
PRHERNAL     0641  0642 numeric    "Allocation flag hourly earnings recode (PRERNHLY)"
HXTENURE     0643  0644 numeric    "Allocation flag"
HXHOUSUT     0645  0646 numeric    "Allocation flag"
HXTELHHD     0647  0648 numeric    "Allocation flag"
HXTELAVL     0649  0650 numeric    "Allocation flag"  
HXPHONEO     0651  0652 numeric    "Allocation flag"                                        
PXINUSYR     0653  0654 numeric    "Allocation flag"
PXRRP        0655  0656 numeric    "Allocation flag"
PXPARENT     0657  0658 numeric    "Allocation flag"
PXAGE        0659  0660 numeric    "Allocation flag"
PXMARITL     0661  0662 numeric    "Allocation flag"
PXSPOUSE     0663  0664 numeric    "Allocation flag"
PXSEX        0665  0666 numeric    "Allocation flag"
PXAFWHN1     0667  0668 numeric    "Allocation flag"
PXAFNOW      0669  0670 numeric    "Allocation flag"
PXEDUCA      0671  0672 numeric    "Allocation flag"
PXRACE1      0673  0674 numeric    "Allocation flag"        
PXNATVTY     0675  0676 numeric    "Allocation flag"
PXMNTVTY     0677  0678 numeric    "Allocation flag"
PXFNTVTY     0679  0680 numeric    "Allocation flag"
PXNMEMP1     0681  0682 numeric    "Allocation flag"
PXHSPNON     0683  0684 numeric    "Allocation flag"
PXMLR        0685  0686 numeric    "Allocation flag"
PXRET1       0687  0688 numeric    "Allocation flag"
PXABSRSN     0689  0690 numeric    "Allocation flag"
PXABSPDO     0691  0692 numeric    "Allocation flag"
PXMJOT       0693  0694 numeric    "Allocation flag"
PXMJNUM      0695  0696 numeric    "Allocation flag"
PXHRUSL1     0697  0698 numeric    "Allocation flag"
PXHRUSL2     0699  0700 numeric    "Allocation flag"
PXHRFTPT     0701  0702 numeric    "Allocation flag"
PXHRUSLT     0703  0704 numeric    "Allocation flag"
PXHRWANT     0705  0706 numeric    "Allocation flag"
PXHRRSN1     0707  0708 numeric    "Allocation flag"
PXHRRSN2     0709  0710 numeric    "Allocation flag"
PXHRACT1     0711  0712 numeric    "Allocation flag"
PXHRACT2     0713  0714 numeric    "Allocation flag"
PXHRACTT     0715  0716 numeric    "Allocation flag"
PXHRRSN3     0717  0718 numeric    "Allocation flag"
PXHRAVL      0719  0720 numeric    "Allocation flag"        
PXLAYAVL     0721  0722 numeric    "Allocation flag" 
PXLAYLK      0723  0724 numeric    "Allocation flag" 
PXLAYDUR     0725  0726 numeric    "Allocation flag" 
PXLAYFTO     0727  0728 numeric    "Allocation flag" 
PXLKM1       0729  0730 numeric    "Allocation flag" 
PXLKAVL      0731  0732 numeric    "Allocation flag" 
PXLKLL1O     0733  0734 numeric    "Allocation flag" 
PXLKLL2O     0735  0736 numeric    "Allocation flag" 
PXLKLWO      0737  0738 numeric    "Allocation flag" 
PXLKDUR      0739  0740 numeric    "Allocation flag" 
PXLKFTO      0741  0742 numeric    "Allocation flag" 
PXDWWNTO     0743  0744 numeric    "Allocation flag" 
PXDWRSN      0745  0746 numeric    "Allocation flag" 
PXDWLKO      0747  0748 numeric    "Allocation flag" 
PXDWWK       0749  0750 numeric    "Allocation flag" 
PXDW4WK      0751  0752 numeric    "Allocation flag" 
PXDWLKWK     0753  0754 numeric    "Allocation flag" 
PXDWAVL      0755  0756 numeric    "Allocation flag" 
PXDWAVR      0757  0758 numeric    "Allocation flag" 
PXJHWKO      0759  0760 numeric    "Allocation flag" 
PXJHRSN      0761  0762 numeric    "Allocation flag" 
PXJHWANT     0763  0764 numeric    "Allocation flag" 
PXIO1COW     0765  0766 numeric    "Allocation flag"
PXIO1ICD     0767  0768 numeric    "Allocation flag" 
PXIO1OCD     0769  0770 numeric    "Allocation flag" 
PXIO2COW     0771  0772 numeric    "Allocation flag" 
PXIO2ICD     0773  0774 numeric    "Allocation flag" 
PXIO2OCD     0775  0776 numeric    "Allocation flag" 
PXERNUOT     0777  0778 numeric    "Allocation flag"
PXERNPER     0779  0780 numeric    "Allocation flag" 
PXERNH1O     0781  0782 numeric    "Allocation flag" 
PXERNHRO     0783  0784 numeric    "Allocation flag" 
PXERN        0785  0786 numeric    "Allocation flag" 
PXPDEMP2     0787  0788 numeric    "Allocation flag" 
PXNMEMP2     0789  0790 numeric    "Allocation flag" 
PXERNWKP     0791  0792 numeric    "Allocation flag" 
PXERNRT      0793  0794 numeric    "Allocation flag" 
PXERNHRY     0795  0796 numeric    "Allocation flag" 
PXERNH2      0797  0798 numeric    "Allocation flag" 
PXERNLAB     0799  0800 numeric    "Allocation flag" 
PXERNCOV     0801  0802 numeric    "Allocation flag"  
PXNLFJH      0803  0804 numeric    "Allocation flag" 
PXNLFRET     0805  0806 numeric    "Allocation flag" 
PXNLFACT     0807  0808 numeric    "Allocation flag" 
PXSCHENR     0809  0810 numeric    "Allocation flag" 
PXSCHFT      0811  0812 numeric    "Allocation flag" 
PXSCHLVL     0813  0814 numeric    "Allocation flag"    
QSTNUM       0815  0819 numeric    "Unique household identifier."
OCCURNUM     0820  0821 numeric    "Unique person identifier."
PEDIPGED     0822  0823 numeric    "How did...get...-s high school diploma?"
PEHGCOMP     0824  0825 numeric    "What was the highest grade of regular school...completed before receiving...-s GED?"
PECYC        0826  0827 numeric    "How many years of college credit has...completed?"
PXDIPGED     0834  0835 numeric    "Allocation flag"
PXHGCOMP     0836  0837 numeric    "Allocation flag"
PXCYC        0838  0839 numeric    "Allocation flag"
PWCMPWGT     0846  0855 numeric    "Composited final weight. Used to create BLS-s published labor force statistics"
PEIO1ICD     0856  0859 numeric    "Industry code for primary job"
PEIO1OCD     0860  0863 numeric    "Occupation code for primary job."
PEIO2ICD     0864  0867 numeric    "Industry code for second job."
PEIO2OCD     0868  0871 numeric    "Occupation code for second job."
PRIMIND1     0872  0873 numeric    "Intermediate industry recode (job 1)"
PRIMIND2     0874  0875 numeric    "Intermediate industry recode (job 2)"
PEAFWHN1     0876  0877 numeric    "When did you serve?"
PEAFWHN2     0878  0879 numeric    "When did you serve?"
PEAFWHN3     0880  0881 numeric    "When did you serve?"
PEAFWHN4     0882  0883 numeric    "When did you serve?"
PXAFEVER     0884  0885 numeric    "Allocation flag"    
PELNDAD      0886  0887 numeric    "Line number of father"            
PELNMOM      0888  0889 numeric    "Line number of mother"      
PEDADTYP     0890  0891 numeric    "Type of father" 
PEMOMTYP     0892  0893 numeric    "Type of mother" 
PECOHAB      0894  0895 numeric    "Line number of cohabiting partner"
PXLNDAD      0896  0897 numeric    "Allocation flag"
PXLNMOM      0898  0899 numeric    "Allocation flag"
PXDADTYP     0900  0901 numeric    "Allocation flag"
PXMOMTYP     0902  0903 numeric    "Allocation flag"
PXCOHAB      0904  0905 numeric    "Allocation flag"
PEDISEAR     0906  0907 numeric    "Is...deaf or does ...have serious difficulty hearing?"
PEDISEYE     0908  0909 numeric    "Is...blind or does...have serious difficulty seeing even when wearing glasses?"
PEDISREM     0910  0911 numeric    "Because of a physical, mental, or emotional condition, does...have serious difficulty concentrating, remembering, or making decisions?"
PEDISPHY     0912  0913 numeric    "Does...have serious difficulty walking or climbing stairs?"
PEDISDRS     0914  0915 numeric    "Does...have difficulty dressing or bathing?"
PEDISOUT     0916  0917 numeric    "Because of a physical, mental, or emotional condition, does...have difficulty doing errands alone such as visiting a doctor-s office or shopping?"
PRDISFLG     0918  0919 numeric    "Does this person have any of these disability conditions?"
PXDISEAR     0920  0921 numeric    "Allocation flag"
PXDISEYE     0922  0923 numeric    "Allocation flag"
PXDISREM     0924  0925 numeric    "Allocation flag"
PXDISPHY     0926  0927 numeric    "Allocation flag"
PXDISDRS     0928  0929 numeric    "Allocation flag"
PXDISOUT     0930  0931 numeric    "Allocation flag"        
HXFAMINC     0932  0933 numeric    "Allocation flag"    
PRDASIAN     0934  0935 numeric    "Detailed Asian race recode"
PEPDEMP1     0936  0937 numeric    "Does this person usually have any paid employees?"
PTNMEMP1     0938  0939 numeric    "Excluding all owners, how many paid employees does this person usually have?"
PEPDEMP2     0940  0941 numeric    "Does this person usually have any paid employees?"
PTNMEMP2     0942  0943 numeric    "Excluding all owners, how many paid employees does this person usually have?"
PECERT1      0944  0945 numeric    "Does...have a currently active professional certification or a state or industry license?"        
PECERT2      0946  0947 numeric    "Were any of -s certifications or licenses issued by the federal, state, or local government?"
PECERT3      0948  0949 numeric    "Earlier you told me that you had a currently active professional certification or license.  Is your certification or license required for your "
PXCERT1      0950  0951 numeric    "Allocation flag"
PXCERT2      0952  0953 numeric    "Allocation flag"          
PXCERT3      0954  0955 numeric    "Allocation flag"
PENXTPR      1001  1002 numeric    "Line number of person being interviewed"        
PENXTPR3     1003  1004 numeric    "Is this self or proxy?"
PEA1         1005  1006 numeric    "(Have/Has) (you/ name) smoked at least 100 cigarettes in (your/his/her) entire life? 100 cigarettes = approximately 5 packs"
PEA2         1007  1009 numeric    "How old (were/was) (you/name) when (you/he/she) first started smoking cigarettes FAIRLY REGULARLY?"
PEA2A        1010  1012 numeric    "You said that (you/name) never smoked regularly.  How old (were/was) (you/name) the first time (you/he/she) smoked part or all of a cigarette?"
PEA3         1013  1014 numeric    "(Do/Does) (you/name) now smoke cigarettes every day, some days, or not at all?"
PTB1         1015  1017 numeric    "On the average, about how many cigarettes do you now smoke each day?"        
PEB1A        1018  1019 numeric    "Would you say that, on average, you now smoke more or less than 20 cigarettes each day?"
PEB2         1020  1021 numeric    "Do you usually smoke menthol or non-menthol cigarettes?" 
PEB5ANUM     1022  1023 numeric    "How soon after you wake up do you typically smoke your first cigarette of the day? (number)"
PEB5AUNT     1024  1025 numeric    "How soon after you wake up do you typically smoke your first cigarette of the day? (unit)"
PEB5B        1026  1027 numeric    "Would you say you smoke your first cigarette of the day within the first 30 minutes?"
PEBA6A       1028  1029 numeric    "Do you usually buy your own cigarettes?"
PEB6A        1030  1031 numeric    "Do you USUALLY buy your cigarettes by the pack or by the carton?"
PTB6B        1032  1036 numeric    "What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons."
PTB6C        1037  1042 numeric    "What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons."
PEB6C4       1043  1044 numeric    "Did you use coupons, rebates, or any other special promotions when you bought your LAST (B6a fill PACK/CARTON) of cigarettes?"
PEB6D1       1045  1046 numeric    "Did you buy your LAST (pack/carton) of cigarettes in (fill respondent-s state of residence) or in some other state?"
PEB6D21      1047  1048 numeric    "In what other state did you buy your LAST (pack/carton) of cigarettes?"
PEB6D3       1049  1050 numeric    "Did you buy you LAST (pack/carton) of cigarettes from an Indian reservation?"
PEB6DOTH     1051  1052 numeric    "Was the Other Way in which you purchased your LAST (pack/carton) of cigarettes:"
PEB6E1       1053  1054 numeric    "In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?"
PEB6E31      1055  1056 numeric    "Did you buy your LAST SINGLE or INDIVIDUAL cigarette in [fill respondent-s state of residence] or in some other state or country?"
PRB6E32A     1057  1059 numeric    "In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?"
PEB6E4       1060  1061 numeric    "In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?"
PEB7C        1062  1063 numeric    "For how long have you smoked EVERY DAY?"
PEB7C2       1064  1065 numeric    "Have you EVER smoked MENTHOL cigarettes for 6 months or more?"
PEB7C3       1066  1067 numeric    "For how long (have you smoked/did you smoke) MENTHOL cigarettes?"
PEB8         1068  1069 numeric    "Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?"
PTB9         1070  1072 numeric    "Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?"
PEB10A       1073  1074 numeric    "Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?"
PTB10B       1075  1077 numeric    "On the average, on those (fill entry B10a) days, how many cigarettes did you usually smoke each day?"
PEC1         1078  1079 numeric    "On how many of the past 30 days did you smoke cigarettes?"
PEC1I        1080  1081 numeric    "Would you say you smoked on at least 12 days in the past 30 days?"
PTC1A        1082  1084 numeric    "On the average, on those (fill entry C1) days, how many cigarettes did you usually smoke each day?"
PEC2         1085  1086 numeric    "Do you usually smoke menthol or non-menthol cigarettes?"
PEC5ANUM     1087  1088 numeric    "On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (number)"        
PEC5AUNT     1089  1090 numeric    "On the days that you smoke, how soon after you wake up do you typically smoke your first cigarette of the day? (unit)"
PEC5B        1091  1092 numeric    "On the days that you smoke, would you say you smoke your first cigarette of the day within the first 30 minutes?"
PECA6A       1093  1094 numeric    "Do you usually buy your own cigarettes?"
PEC6A        1095  1096 numeric    "Do you USUALLY buy your cigarettes by the pack or by the carton?"
PTC6B        1097  1101 numeric    "What price did you pay for the LAST pack of cigarettes you bought? Please report the cost after using discounts or coupons."
PTC6C        1102  1107 numeric    "What price did you pay for the LAST carton of cigarettes you bought? Please report the cost after using discounts or coupons."
PEC6C4       1108  1109 numeric    "Did you use coupons, rebates, or any other special promotions when you bought your LAST (pack/carton) of cigarettes?"
PEC6D1       1110  1111 numeric    "Did you buy your LAST (pack/carton) of cigarettes in (fill respondent-s state of residence) or in some other state?"
PEC6D21      1112  1113 numeric    "In what other state did you buy your LAST (pack/carton) of cigarettes?"
PEC6D3       1114  1115 numeric    "Did you buy your LAST (pack/carton) of cigarettes from an Indian reservation?"
PEC6DOTH     1116  1117 numeric    "Was the -Other Way- in which you purchased your Last (pack/carton) of cigarettes."
PEC6E1       1118  1119 numeric    "In the LAST 2 months, have you bought any SINGLE or INDIVIDUAL cigarettes?"
PEC6E31      1120  1121 numeric    "Did you buy your LAST SINGLE or INDIVIDUAL cigarette in (fill respondent-s state of residence) or in some other state or other country?"
PRC6E32A     1122  1124 numeric    "In what OTHER state or country did you buy your LAST SINGLE OR INDIVIDUAL cigarette?"
PEC6E4       1125  1126 numeric    "In the LAST 2 months, have you bought loose tobacco to roll-your-own cigarettes?"
PEC7A        1127  1128 numeric    "Have you EVER smoked cigarettes EVERY DAY for at least 6 months?"
PEC7D        1129  1130 numeric    "For how long did you smoke EVERY DAY?"
PEC7D2       1131  1132 numeric    "Have you EVER smoked MENTHOL cigarettes for 6 months or more?"
PEC7D3       1133  1134 numeric    "For how long (have you smoked/did you smoke) MENTHOL cigarettes?"
PTC7E        1135  1136 numeric    "When you last smoked every day, on average how many cigarettes did you smoke each day?"
PEC8         1137  1138 numeric    "Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?"
PTC9         1139  1141 numeric    "Around this time 12 months ago, on the average about how many cigarettes did you smoke each day?"
PEC10A       1142  1143 numeric    "Around this time 12 months age, on how many of 30 days in the month did you smoke cigarettes?"
PTC10B       1144  1146 numeric    "On the average, on those (fill entry c10a) days, how many cigarettes did you usually smoke each day?"
PEDA         1147  1148 numeric    "During the PAST 12 MONTHS, have you TRIED to QUIT smoking COMPLETELY?"
PEDB         1149  1150 numeric    "Have you EVER TRIED to QUIT smoking COMPLETELY?"
PED1R        1151  1152 numeric    "During the PAST 12 MONTHS, have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?"
PED3         1153  1154 numeric    "How many TIMES during the past 12 months have you stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING?"
PED3B        1155  1156 numeric    "Would you say that during the past 12 months it was MORE THAN 3 TIMES that you have stopped smoking for one day or longer BECAUSE YOU WERE TRYING TO QUIT SMOKING/TRIED to QUIT smoking COMPLETELY?"
PED6NUM      1157  1158 numeric    "During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (number)"
PED6UNT      1159  1160 numeric    "During the PAST 12 MONTHS, what is the length of this single quit attempt where you stopped smoking because you were TRYING to quit smoking? (unit)"          
PED6B        1161  1162 numeric    "Was it more or less than one week?"
PED6CNUM     1163  1164 numeric    "Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (number)"
PED6CUNT     1165  1166 numeric    "Thinking of those attempts during the past 12 months, what was the length of time of the ONE attempt that lasted the longest? (unit)"
PED6C2       1167  1168 numeric    "Was it more or less than one week?"          
PED7R        1169  1170 numeric    "DURING THE PAST 12 MONTHS, have you made a serious attempt to stop smoking because you were TRYING to quit even if you stopped for less than a day?"
PED8R        1171  1172 numeric    "Have you EVER made a serious attempt to stop smoking because you were -TRYING to quit-; even if you stopped for less than a day?"
PEE1A123     1173  1174 numeric    "Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A NICOTINE patch, gum, lozenge, nasal spray or inhaler?"
PEE1A7AB     1175  1176 numeric    "Thinking back to the (LAST TIME/time) you tried to QUIT smoking in the past 12 months: Did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?"
PEE1B1       1177  1178 numeric    "Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A telephone help line or quit line?"
PEE1B2       1179  1180 numeric    "Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?"
PEE1B3       1181  1182 numeric    "Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: A stop smoking clinic, class, or support group?"
PEE1B5       1183  1184 numeric    "Thinking back to the (last time/time) you tried to QUIT smoking in the past 12 months. Did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?"
PEE1C2       1185  1186 numeric    "The (last time/time) you tried to QUIT smoking in the past 12 months: Did you do ANY of the following: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?"
PEE1C2B      1187  1188 numeric    "The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or any pipes filled with tobacco?"
PEE1C2C      1189  1190 numeric    "The (last time/time) you tried to QUIT smoking in the past 12 months. Did you do ANY of the following: Try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods."
PEE1C2D1     1191  1192 numeric    "Did you switch to? Cigars, cigarillos, little filtered cigars."
PEE1C2D2     1193  1194 numeric    "Did you switch to? Regular pipes filled with tobacco."
PEE1C2D3     1195  1196 numeric    "Did you switch to? Water or hookah (pronounced who-kah) pipes filled with tobacco."
PEE1CZ2C     1197  1198 numeric    "The (LAST TIME/TIME) you tried to quit smoking in the past 12 months, did you try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookah, vapes or mods."
PEF1A        1199  1200 numeric    "In the PAST 12 MONTHS, have you seen a medical doctor?"
PEF1B        1201  1202 numeric    "During the PAST 12 MONTHS, did any medical doctor ADVISE you to stop smoking?"
PEG1         1203  1204 numeric    "Are you seriously considering quitting smoking within the next 6 months?"
PEG2         1205  1206 numeric    "Are you planning to quit within the next 30 days?"
PEG3         1207  1208 numeric    "Overall, on a scale from 1 to 10 where 1 is NOT AT ALL interested and 10 is EXTREMELY interested, how interested are you in quitting smoking?"
PEG4         1209  1210 numeric    "If you did try to quit smoking altogether in the next 6 months, how LIKELY do you think you would be to succeed --not at all, a little likely, somewhat likely or very likely?"
PEH1NUM      1211  1212 numeric    "About how long has it been since you COMPLETELY quit smoking cigarettes? (number)"
PEH1UNT      1213  1214 numeric    "About how long has it been since you COMPLETELY quit smoking cigarettes? (unit)"
PEH1B        1215  1216 numeric    "In the PAST 12 months, was H1 the longest time you stopped smoking cigarettes because you were trying to quit?"
PEH1CNUM     1217  1218 numeric    "During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (number)"
PEH1CUNT     1219  1220 numeric    "During the PAST 12 MONTHS, what WAS the LONGEST length of time you stopped smoking because you were TRYING to quit smoking... (unit)"          
PEH2         1221  1222 numeric    "Have you EVER smoked cigarettes EVERY DAY for at least 6 months?"
PEH5         1223  1224 numeric    "For how long did you smoke EVERY DAY?"
PTH5A        1225  1226 numeric    "When you last smoked every day, on average how many cigarettes did you smoke each day?"
PEH6         1227  1228 numeric    "Around this time 12 MONTHS AGO, were you smoking cigarettes every day, some days, or not at all?"
PTH6A        1229  1230 numeric    "Around this time 12 MONTHS AGO, on the average, about how many cigarettes did you smoke each day?"
PEH6B        1231  1232 numeric    "Around this time 12 MONTHS AGO, on how many of 30 days in the month did you smoke cigarettes?"
PTH6C        1233  1234 numeric    "On the average, on those (Fill PEH6b entry), how many cigarettes did you usually smoke each day?"
PEH6C2       1235  1236 numeric    "We are still talking about Around this time 12 months ago. Thinking back to the 12 MONTHS BEFORE YOU QUIT SMOKING CIGARETTES, during that time, did you usually smoke menthol or non-menthol cigarettes?"
PEH6C4       1237  1238 numeric    "Have you EVER smoked MENTHOL cigarettes for 6 months or more?"
PEH6C5       1239  1240 numeric    "For how long have you smoked MENTHOL cigarettes?"
PEH6D123     1241  1242 numeric    "Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A NICOTINE patch, gum, lozenge, nasal spray or inhaler?"
PEH6D7AB     1243  1244 numeric    "Now I would like to ask about HOW you went about completely quitting smoking.  When you quit smoking completely, did you use ANY of the following PRODUCTS: A prescription pill, called Chantix, Varenicline, Zyban, Bupropion, or Wellbutrin?"
PEH6E1       1245  1246 numeric    "When you quit smoking completely, did you use ANY of the following: A telephone help line or quit line?"
PEH6E2       1247  1248 numeric    "When you quit smoking completely, did you use ANY of the following: One-on-one IN-PERSON counseling by a health professional?"
PEH6E3       1249  1250 numeric    "When you quit smoking completely, did you use ANY of the following: A stop smoking clinic, class, or support group?"
PEH6E5       1251  1252 numeric    "When you quit smoking completely, did you use ANY of the following: Internet or a web-based program or tool including smartphone apps and text messaging programs?"
PEH6FA2      1253  1254 numeric    "When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?"
PEH6FA2B     1255  1256 numeric    "When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to regular cigars, cigarillos, little filtered cigars or ANY pipes filled with tobacco?"
PEH6FA2C     1257  1258 numeric    "When you quit smoking completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-Cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods."
PEH6FA2D1    1259  1260 numeric    "Did you switch to? Cigars, cigarillos, little filtered cigars."
PEH6FA2D2    1261  1262 numeric    "Did you switch to? Regular pipes filled with tobacco."
PEH6FA2D3    1263  1264 numeric    "Did you switch to? Water or hookah pipes filled with tobacco."
PEH6FAZ2C    1265  1266 numeric    "When you quit smoking completely, did you try to quit by SWITCHING to electronic or E-cigarettes? You may also know them as vape-pens, e-hookahs, vapes or mods."
PEH61A       1267  1268 numeric    "In the 12 MONTHS BEFORE you COMPLETELY quit smoking, did you SEE a medical doctor?"
PEH61B       1269  1270 numeric    "During the 12 MONTHS BEFORE you completely quit smoking, did any medical doctor ADVISE you to stop smoking?"
PEH8ANUM     1271  1272 numeric    "During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (number)"
PEH8AUNT     1273  1274 numeric    "During the 12 MONTHS before you quit smoking, how soon after you woke up did you typically smoke your first cigarette of the day? (unit)"
PEH8B        1275  1276 numeric    "During the 12 months before you quit smoking, would you say you smoked your first cigarette of the day within the first 30 minutes of awakening?"
PEH11A       1277  1278 numeric    "Thinking back to the 12 MONTHS BEFORE YOU COMPLETELY QUIT SMOKING CIGARETTES. During that time, DID YOU USUALLY SMOKE menthol or non-menthol cigarettes?"
PEH11C       1279  1280 numeric    "Have you EVER smoked MENTHOL cigarettes for 6 months or more?"
PEH11D       1281  1282 numeric    "For how long did you smoked MENTHOL cigarettes?"  
PEJ1A1       1283  1284 numeric    "(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular cigar or cigarillo OR a little filtered cigar?"
PEJ1A2       1285  1286 numeric    "(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... A regular pipe filled with tobacco?"
PEJ1A3       1287  1288 numeric    "(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... a water pipe or hookah (who-kah) pipe filled with tobacco?"
PEJ1A3_5     1289  1290 numeric    "(Have/Has) (you/name) EVER used E-cigarettes EVEN ONE TIME?"
PEJ1A4       1291  1292 numeric    "(Have/Has) (you/name) EVER used any of the following EVEN ONE TIME? ... Smokeless tobacco, such as moist snuff, dip, spit, chew tobacco or snus?"    
PEJ1A5       1293  1294 numeric    "(Have/Has) (you/name) EVER used disolvable tobacco EVEN ONE TIME?"
PEJ2A1       1295  1296 numeric    "(Do you/Does name) NOW smoke regular cigars or cigarillos or little filtered cigars every day, some days or not at all?"
PEJ2B1       1297  1298 numeric    "On how many of the past 30 days did you smoke regular cigars or cigarillos or little filtered cigars?"
PEJ2A2       1299  1300 numeric    "(Do you/Does name) NOW smoke a regular pipe every day, some days or not at all?"
PEJ2B2       1301  1302 numeric    "On how many of the past 30 days did you smoke a regular pipe?"
PEJ2A3       1303  1304 numeric    "(Do you/Does name) NOW use a water pipe or hookah pipe filled with tobacco every day, some days or not at all?"
PEJ2B3       1305  1306 numeric    "On how many of the past 30 days did you use a water pipe or hookah pipe filled with tobacco?"
PEJ2A3_5     1307  1308 numeric    "(Do you /Does name) NOW use an E-cigarette every day, some days or not at all?"
PEJ2B3_5     1309  1310 numeric    "On how many of the past 30 days did you use an E-cigarette?"
PEJ2A4       1311  1312 numeric    "(Do you /Does name) NOW use smokeless tobacco such as moist snuff, dip, spit, chew tobacco or snus every day, some days or not at all?"
PEJ2B4       1313  1314 numeric    "On how many of the past 30 days did you use smokeless tobacco?"
PEJ2A5       1315  1316 numeric    "(Do you /Does name) NOW use dissolvable tobacco every day, some days or not at all?"
PEJ2B5       1317  1318 numeric    "On how many of the past 30 days did you use dissolvable tobacco?"
PEJA         1319  1320 numeric    "During the past 30 days, what BRAND of smokeless tobacco (If necessary: moist snuff, dip, spit, chew or snus) did you use MOST OFTEN?"
PEJB         1321  1322 numeric    "During the PAST 30 days, what type of CIGAR did you use MOST OFTEN?"
PEJC         1323  1324 numeric    "During the PAST 30 days, what BRAND of CIGAR did you smoke MOST OFTEN?"
PEJNFLVIN    1325  1326 numeric    "Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol,or other flavors."
PEJNFLVR1    1327  1328 numeric    "Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a cigar is it usually flavored?"
PEJNFLA1B    1329  1330 numeric    "Is it usually menthol or mint flavored?"
PEJNFLA1C    1331  1332 numeric    "Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?"
PEJNFLA1D    1333  1334 numeric    "Is it usually some other type of flavor?"
PEJNFLVR2    1335  1336 numeric    "Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a regular pipe filled with tobacco is it usually flavored?"
PEJNFLA2B    1337  1338 numeric    "Is it usually menthol or mint flavored?"
PEJNFLA2C    1339  1340 numeric    "Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?"
PEJNFLA2D    1341  1342 numeric    "Is it usually some other type of flavor?"
PEJNFLVR3    1343  1344 numeric    "Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you smoke a water/hookah pipe filled with tobacco is it usually flavored?"
PEJNFLA3B    1345  1346 numeric    "Is it usually menthol or mint flavored?"
PEJNFLA3C    1347  1348 numeric    "Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?"
PEJNFLA3D    1349  1350 numeric    "Is it usually some other type of flavor?"
PEJNFLV35    1351  1352 numeric    "Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use an E-cigarette is it usually flavored?"
PEJNFA35A    1353  1354 numeric    "Is it usually tobacco flavored?"
PEJNFA35B    1355  1356 numeric    "Is it usually menthol or mint flavored?"
PEJNFA35C    1357  1358 numeric    "Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?"
PEJNFA35D    1359  1360 numeric    "Is it usually some other type of flavor?"
PEJNFVB35    1361  1362 numeric    "When you use an e-cigarette, is it usually tobacco flavored?"
PEJNFLVR4    1363  1364 numeric    "Some tobacco products come in flavors such as menthol or mint, clove, spice, fruit, chocolate, alcohol, or other flavors.  When you use smokeless tobacco is it usually flavored?"
PEJNFLA4B    1365  1366 numeric    "Is it usually menthol or mint flavored?"
PEJNFLA4C    1367  1368 numeric    "Is it usually flavored like clove, spice, herb, fruit, alcohol, candy, sweets, or chocolate?"
PEJNFLA4D    1369  1370 numeric    "Is it usually some other type of flavor?"
PEJECIGRA    1371  1372 numeric    "Do you use e-cigarettes because you can use them at times when or in places where smoking cigarettes isn-t allowed?"
PEJECIGRD    1373  1374 numeric    "Do you use e-cigarettes to help you quit smoking cigarettes?"
PEJECIG2     1375  1376 numeric    "Which of the following best describes the type of e-cigarette you currently use?"
PEJECIG3     1377  1378 numeric    "Do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?"
PEJECIG4     1379  1380 numeric    "How do you usually buy your own {e-cigarettes/e-cigarette cartridges/e-liquid}?"
PEJCOST1     1381  1382 numeric    "Do you usually buy {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} by the box or pack, or as {single e-cigarettes/single e-cigarette cartridges/a single bottle of e-liquid}?"
PTJCOST2     1383  1387 numeric    "What price did you pay for the LAST BOX OR PACK of {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} you bought?  Please report the cost after using discounts or coupons."
PEJCOST3     1388  1390 numeric    "How many {e-cigarettes/e-cigarette cartridges/bottles of e-liquid} came in the LAST BOX OR PACK you bought?"
PTJCOST4     1391  1395 numeric    "What price did you pay for the LAST {e-cigarette/e-cigarette cartridge/bottle of e-liquid} you bought?  Please report the cost after using discounts or coupons."
PEJCOST5     1396  1399 numeric    "How many MILLILITERS of liquid were in a SINGLE bottle you LAST bought?"
PEJD11       1400  1401 numeric    "About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (number)"
PEJD21       1402  1403 numeric    "About how long has it been since you COMPLETELY quit smoking cigars, cigarillos or little filter cigars? (unit)"
PEJD12       1404  1405 numeric    "About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (number)"
PEJD22       1406  1407 numeric    "About how long has it been since you COMPLETELY quit smoking a regular pipe filled with tobacco? (unit)"
PEJD13       1408  1409 numeric    "About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (number)"
PEJD23       1410  1411 numeric    "About how long has it been since you COMPLETELY quit smoking a water pipe or hookah pipe filled with tobacco? (unit)"
PEJD13_5     1412  1413 numeric    "About how long has it been since you COMPLETELY quit using E-cigarettes? (number)"
PEJD23_5     1414  1415 numeric    "About how long has it been since you COMPLETELY quit using E-cigarettes? (unit)"
PEJD14       1416  1417 numeric    "About how long has it been since you COMPLETELY quit using a smokeless tobacco? (number)"
PEJD24       1418  1419 numeric    "About how long has it been since you COMPLETELY quit using a smokeless tobacco? (unit)"
PEJD31       1420  1421 numeric    "In total, how many years (have you smoked/did you smoke) cigars or cigarillos or little filtered cigars?"
PEJD32       1422  1423 numeric    "In total, how many years (have you smoked/did you smoke) a regular pipe filled with tobacco?"
PEJD33       1424  1425 numeric    "In total, how many years (have you smoked/did you smoke) a water pipe or hookah pipe filled with tobacco?"
PEJD33_5     1426  1427 numeric    "In total, how many years (have you used/did you use) an E-cigarette?"
PEJD34       1428  1429 numeric    "In total, how many years (have you used/did you use) smokeless tobacco?"
PEJFECGRA    1430  1431 numeric    "Did you use E-cigarettes because you could use them at times when or in places where smoking cigarettes wasn-t allowed?"
PEJFECGRD    1432  1433 numeric    "Did you use e-cigarettes to help you quit smoking cigarettes? "
PEJFECG2     1434  1435 numeric    "Which of the following best describes the type of e-cigarette you used to use?  If you used more than one type, please think of the one you used most often."
PEJ3A1       1436  1437 numeric    "How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (number)"
PEJ3A2       1438  1439 numeric    "How soon after you wake up do you typically (fill text from PRJ3A1F recode)? (unit)"
PEJ3D        1440  1441 numeric    "Would you say you first (fill text from PRJ3DF recode) within the first 30 minutes of awakening?"
PEJ3F1       1442  1443 numeric    "In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (number)"
PEJ3F2       1444  1445 numeric    "In the 12 months BEFORE YOU COMPLETELY QUIT (Fill text from PRJ3F1F recode), how soon after you woke up did you typically (Fill text from PRJ3F1F recode)? (unit)"
PEJ3G        1446  1447 numeric    "Would you say you first used (Fill text from PRJ3GF recode) within the first 30 minutes of awakening?"
PEJ4         1448  1449 numeric    "During the PAST 12 MONTHS, have you stopped (Fill text from PRJ4F recode) for one day or longer BECAUSE YOU WERE TRYING TO QUIT?"
PEJ6BNUM     1450  1451 numeric    "Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (number)"
PEJ6BUNT     1452  1453 numeric    "Thinking of ANY attempts to stop (fill text from PRJ6BNMF) because you were trying to quit, during the past 12 MONTHS, what is the LONGEST length of time of the ONE attempt that lasted the longest? (unit)"
PEJ7CINT     1454  1455 numeric    "The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you:"
PEJ7C        1456  1457 numeric    "The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to smokeless tobacco such as chewing  tobacco, snuff, or snus?"
PEJ7D        1458  1459 numeric    "The LAST TIME you tried to QUIT smoking CIGARS in the past 12 months: Did you: Try to quit by SWITCHING to electronic or E-cigarettes?"
PEJ7ALTIN    1460  1461 numeric    "When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective:"
PEJ7CALT     1462  1463 numeric    "When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to smokeless tobacco such as chewing tobacco, snuff, or snus?"
PEJ7DALT     1464  1465 numeric    "When you quit smoking CIGARS completely, did you do ANY of the following, whether or not you think they were effective: Try to quit by SWITCHING to electronic or E-cigarette?"
PEK1A        1466  1467 numeric    "Do you mainly work indoors or outdoors?"
PEK1B        1468  1469 numeric    "Do you mainly work in an office building, your own home, in someone else-s home, or in another indoor place?"
PEK1B11      1470  1471 numeric    "In which State (including DC), do you work?"
PEK1B2       1472  1473 numeric    "When you work INDOORS: Do you mainly work in an office building, in your own home, in someone else-s home, or in another indoor place?"
PEK1C1       1474  1475 numeric    "In which State (including DC), do you work on your main indoor job or business?"
PEK2A        1476  1477 numeric    "Is smoking restricted in ANY WAY at your place of work?"
PEK3A        1478  1479 numeric    "Which of these best describes the smoking policy at your place of work for INDOOR PUBLIC OR COMMON AREAS, such as lobbies, rest rooms, and lunch rooms?"
PEK3B        1480  1481 numeric    "Which of these best describes the smoking policy at your place of work for INDOOR WORK AREAS?"
PEK3C        1482  1483 numeric    "During the PAST TWO WEEKS, has anyone smoked in the area in which you work?"
PEK3B1       1484  1485 numeric    "Which of these best describes the vaping or e-cigarette policy at your place of work for INDOOR PUBLIC OR COMMON AREAS AND INDOOR WORK AREAS?"
PEK3C1       1486  1487 numeric    "During the PAST TWO WEEKS, has anyone vaped or used e-cigarettes in the area in which you work?"
PEK4         1488  1489 numeric    "Which statement best describes the rules about smoking INSIDE YOUR HOME?"
PEK4A        1490  1491 numeric    "Which statement best describes the rules about vaping or using e-cigarettes INSIDE YOUR HOME?"
PEK5A        1492  1493 numeric    "In buildings with MULTIPLE apartments or living areas, do you THINK that smoking should be ... ALLOWED INSIDE ALL apartments or living areas, ALLOWED inside SOME apartments ..., or NOT ALLOWED at ALL inside apartments?"
PEK6B        1494  1495 numeric    "In indoor work areas, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?"
PEK6C        1496  1497 numeric    "Inside bars, cocktail lounges, and clubs, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?"
PEK6G        1498  1499 numeric    "Inside casinos, do you THINK that smoking SHOULD be allowed in ALL areas, allowed in SOME areas, or NOT allowed at ALL?"
PEK6H        1500  1501 numeric    "Inside a car, when there are other people present, do you THINK that smoking SHOULD..."
PEK6H2       1502  1503 numeric    "IF children are present inside the car, do you think that smoking SHOULD..."
PEK8         1504  1505 numeric    "In the past 6 months, have you seen messages in newspapers or on television that say that a Federal Court has ordered tobacco companies to make statements about the dangers of smoking cigarettes?"
PEK9INTRO    1506  1507 numeric    "The last few questions are about heated tobacco products. Some people refer to these as -heat-not-burn- tobacco products. These heat TOBACCO STICKS or CAPSULES to produce a vapor. They are different from e-cigar....."
PEK9         1508  1509 numeric    "Before today, have you heard of -heated tobacco products-?"
PEK10        1510  1511 numeric    "Have you ever tried a -heated tobacco product-, even just one time?"          
PES78        1512  1513 numeric    "Respondent relationship recode - relationship of respondent to the sample person"
PESINTTP     1514  1515 numeric    "In what language was the interview conducted for this person?"
PES81A       1516  1517 numeric    "Method of Interview"
INTRVIEW     1518  1519 numeric    "Interview Status Recode"
HRMODE       1520  1521 numeric    "Method of Interview"
SMOKSTAT     1522  1523 numeric    "Type of smoker recode"
PRS35        1524  1525 numeric    "Respondent and Smoker Type"
PRS60        1526  1527 numeric    "Self responding -Not at all- smokers- smoking less than or equal to 1 year or don-t know"
PRS64        1528  1529 numeric    "Who is responding for the supplement"
PRS65        1530  1531 numeric    "Monthly Labor Force recode of Self respondents"
PRS66        1532  1533 numeric    "Employed self respondents- class of worker on first job"
PRJ3A1F      1534  1535 numeric    "Recode from fill in PEJ3a1 and PEJ3a2 to determine which tobacco product is being discussed in PEJ3a1 and PEJ3a2"
PRJ3DF       1536  1537 numeric    "Recode from fill in PEJ3d to determine which tobacco product is being discussed in PEJ3d"
PRJ3F1F      1538  1539 numeric    "Recode from fill in PEJ3f1 and PEJ3f2 to determine which tobacco product is being discussed in PEJ3f1 and PEJ3f2"
PRJ3GF       1540  1541 numeric    "Recode from fill in PEJ3g to determine which tobacco product is being discussed in PEJ3g"
PRJ4F        1542  1543 numeric    "Recode from fill in PEJ4 to determine which tobacco product is being discussed in PEJ4"
PRJ6BNMF     1544  1545 numeric    "Recode from fill in PEJ6bnum and PEJ6bunt to see which tobacco product is being discussed in PEJ6bnum and PEJ6bunt"
PRSIFLG      1546  1547 numeric    "Recode identifies person answering their own questions on the shorter proxy path."
PWNRWGT      1548  1557 numeric    "Nonresponse weight"
PWSRWGT      1558  1567 numeric    "Self response weight"
PEELGFLG     1568  1569 numeric    "Eligibility Flag"'

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg")
getwd()

##################################################################################
# Location of CPS files
##################################################################################


cpsdatamay19 <- "../../../../TUS 2018-2019 data/may19pub.dat"


##################################################################################
# Create data dictionary
##################################################################################
tmp_file <- tempfile()
writeLines(data_diccionary, tmp_file)
data_diccionary_table <- read.table(tmp_file,sep="", col.names = c("variable", "initial_position","final_position", "type", "label"))

### Set varaible type numeric to "n" and characeter to "c"
levels(data_diccionary_table$type)<-c("c","n")
data_diccionary_tabletype <- as.character(data_diccionary_table$type)

### Create list for varaible name and type 
names(data_diccionary_tabletype) <-  data_diccionary_table$variable
data_diccionary_tabletype <- as.list(data_diccionary_tabletype)

##################################################################################
## Reading May 2019 CPS data
##

CPSMAY19 <- as.data.frame(read_fwf(cpsdatamay19, 
 col_positions = fwf_positions( data_diccionary_table$initial_position, 
                 data_diccionary_table$final_position,
                  col_names= data_diccionary_table$variable),
                 col_types = data_diccionary_tabletype  )) 

##################################################################################
## Attaching labels
##################################################################################
for (i in 1:length(data_diccionary_table$variable))
{
  attr(CPSMAY19[,i],"label") <- data_diccionary_table$label[i]
}
dim(CPSMAY19)

##################################################################################
### Recoding varaibles

CPSMAY19$HWHHWGT  <-  CPSMAY19$HWHHWGT/10000
CPSMAY19$PUERNH1C[CPSMAY19$PUERNH1C > 0] <- CPSMAY19$PUERNH1C[CPSMAY19$PUERNH1C>0] /100
CPSMAY19$PEERNH[CPSMAY19$PEERNH != -1] <- CPSMAY19$PEERNH[CPSMAY19$PEERNH !=-1]/100
CPSMAY19$PEERNH1O[CPSMAY19$PEERNH1O > 0] <- CPSMAY19$PEERNH1O[CPSMAY19$PEERNH1O > 0]/100
CPSMAY19$PRERNHLY[CPSMAY19$PRERNHLY != -1 ] <- CPSMAY19$PRERNHLY[CPSMAY19$PRERNHLY != -1 ]/100
CPSMAY19$PRERNWA[CPSMAY19$PRERNWA != -1] <- CPSMAY19$PRERNWA[CPSMAY19$PRERNWA != -1]/100
CPSMAY19$PEERN[CPSMAY19$PEERN != -1] <- CPSMAY19$PEERN[CPSMAY19$PEERN != -1]/100
CPSMAY19$PUERN2[CPSMAY19$PUERN2 != -1] <- CPSMAY19$PUERN2[CPSMAY19$PUERN2 != -1]/100

CPSMAY19$PWFMWGT  <-  CPSMAY19$PWFMWGT/10000
CPSMAY19$PWLGWGT  <-  CPSMAY19$PWLGWGT/10000 
CPSMAY19$PWORWGT  <-  CPSMAY19$PWORWGT/10000
CPSMAY19$PWSSWGT  <-  CPSMAY19$PWSSWGT/10000
CPSMAY19$PWVETWGT  <- CPSMAY19$PWVETWGT/10000
CPSMAY19$PWCMPWGT  <- CPSMAY19$PWCMPWGT/10000        

CPSMAY19$PTB6B[CPSMAY19$PTB6B >0 ] <- CPSMAY19$PTB6B[CPSMAY19$PTB6B >0 ]/100
CPSMAY19$PTB6C[CPSMAY19$PTB6C >0 ] <- CPSMAY19$PTB6C[CPSMAY19$PTB6C >0 ] /100

CPSMAY19$PTC6B[CPSMAY19$PTC6B >0 ] <- CPSMAY19$PTC6B[CPSMAY19$PTC6B >0 ]/100
CPSMAY19$PTC6C[CPSMAY19$PTC6C >0 ] <- CPSMAY19$PTC6C[CPSMAY19$PTC6C >0 ]/100
CPSMAY19$PTJCOST2[CPSMAY19$PTJCOST2 >0 ] <- CPSMAY19$PTJCOST2[CPSMAY19$PTJCOST2 >0 ]/100
CPSMAY19$PTJCOST4[CPSMAY19$PTJCOST4 >0 ] <- CPSMAY19$PTJCOST4[CPSMAY19$PTJCOST4 >0 ]/100

CPSMAY19$PWNRWGT  <-  CPSMAY19$PWNRWGT/10000       
CPSMAY19$PWSRWGT  <-  CPSMAY19$PWSRWGT/10000     
          

##################################################################################
## Saving CPS18 data as a RDS File
##################################################################################

str(CPSMAY19, list.len=ncol(CPSMAY19))

saveRDS(CPSMAY19, file = "../data/CPSMAY19.RDS")


